/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class DeskBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<DeskBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_4719.field_46535.fieldOf("wood_type").forGetter(block -> block.type), (App)DeskBlock.method_54096()).apply((Applicative)builder, DeskBlock::new));
    protected final class_4719 type;

    public DeskBlock(class_4719 type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public class_4719 getWoodType() {
        return this.type;
    }

    protected MapCodec<? extends DeskBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 topShape = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 backLeftLegShape = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
        class_265 backRightLegShape = class_2248.method_9541((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
        class_265 frontLeftLegShape = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)2.0);
        class_265 frontRightLegShape = class_2248.method_9541((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (class_2680 state : states) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            boolean left = (Boolean)state.method_11654((class_2769)LEFT);
            boolean right = (Boolean)state.method_11654((class_2769)RIGHT);
            ArrayList<class_265> shapes = new ArrayList<class_265>();
            shapes.add(topShape);
            if (!left) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backRightLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontRightLegShape, direction));
            }
            if (!right) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(backLeftLegShape, direction));
                shapes.add(VoxelShapeHelper.rotateHorizontally(frontLeftLegShape, direction));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 newPos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)DIRECTION);
        boolean left = this.isConnectable(level, pos, facing.method_10170(), facing);
        boolean right = this.isConnectable(level, pos, facing.method_10160(), facing);
        return (class_2680)((class_2680)state.method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(left))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    public boolean isConnectable(class_1936 level, class_2338 pos, class_2350 checkDirection, class_2350 tableDirection) {
        class_2680 state = level.method_8320(pos.method_10093(checkDirection));
        return state.method_26204() instanceof DeskBlock && state.method_11654((class_2769)DIRECTION) == tableDirection;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEFT});
        builder.method_11667(new class_2769[]{RIGHT});
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33713, ModTags.Blocks.TUCKABLE);
    }
}

